<div>
    <h2>All Payments</h2>

    
    <!--[if BLOCK]><![endif]--><?php if(isset($errorMessage)): ?>
        <div class="alert alert-danger"><?php echo e($errorMessage); ?></div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    
    <div class="row mb-3">
        <div class="col-md-3">
            <input type="date" wire:model="startDate" class="form-control" placeholder="Start Date">
        </div>
        <div class="col-md-3">
            <input type="date" wire:model="endDate" class="form-control" placeholder="End Date">
        </div>
    </div>

    
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Customer Name</th>
                <th>Loan Amount</th>
                <th>Paid Amount</th>
                <th>Payment Date</th>
                <th>Payment Method</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($payment->id); ?></td>
                    <td><?php echo e($payment->user_name); ?></td>
                    <td><?php echo e(number_format($payment->loan_amount, 2)); ?></td>
                    <td><?php echo e(number_format($payment->paid_amount, 2)); ?></td>
                    <td><?php echo e($payment->payment_date); ?></td>
                    <td><?php echo e($payment->payment_method); ?></td>
                    <td><?php echo e($payment->status); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-center">No payments found.</td>
                </tr>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </tbody>
    </table>

    
    <?php echo e($payments->links()); ?>

</div>
<?php /**PATH /var/www/html/nkcng/resources/views/livewire/all-payments-component.blade.php ENDPATH**/ ?>