<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <title>Login</title>

        <link href="<?php echo e(asset('css/bootstrap.min.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('font-awesome/css/font-awesome.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
        <link href="<?php echo e(asset('css/animate.css')); ?>" rel="stylesheet">
    </head>

    <body class="gray-bg">
        <div class="middle-box animated fadeInDown">
            <div class="p-4 p-md-0">
                <div>
                    <h1 class="logo-name text-center" style="color:#F3F3F4;">
                        <img src="<?php echo e(asset('/img/logo.png')); ?>" width="150px" height="150px" alt="Logo">
                    </h1>
                </div>

                <form class="m-t" role="form" action="/login" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <label for="phone_number" class="sr-only">Phone Number</label>
                        <input type="text" class="form-control col-md-12" name="phone_number" id="phone_number" placeholder="Phone Number" value="<?php echo e(old('phone_number')); ?>" autocomplete="off">

                        <?php $__errorArgs = ['phone_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p style="color:red; font-size:0.9rem; margin-top:8px; line-height:1rem;"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group">
                        <label for="password" class="sr-only">Password</label>
                        <input type="password" class="form-control col-md-12" name="password" id="password" placeholder="Password" value="<?php echo e(old('password')); ?>" autocomplete="off">

                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p style="color:red; font-size:0.9rem; margin-top:8px; line-height:1rem;"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <button type="submit" class="btn btn-primary block m-b col-md-12">Login</button>
                    Don't have an account ? <a href="/registration">Create Account</a>
                </form>
            </div>
        </div>

        <script src="<?php echo e(asset('js/jquery-3.1.1.min.js')); ?>"></script>
        <script src="<?php echo e(asset('js/popper.min.js')); ?>"></script>
        <script src="<?php echo e(asset('js/bootstrap.js')); ?>"></script>
    </body>
</html>
<?php /**PATH /var/www/html/nkcng/resources/views/auth/login.blade.php ENDPATH**/ ?>